const express = require("express");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const { createAgentCustomer, getAllAgents, getAllCustomerByAgentCode } = require("../../../controllers/agent-customer");

const { addAgentCustomer } = require("../../../controllers/v1.1/agent-customer");

const router = express.Router();

// Routes
router.post("/create", isAuth, [body("agent").notEmpty(), body("customer").notEmpty()], createAgentCustomer);

router.get("/show-all", getAllAgents);
router.get("/agent-customer", isAuth, getAllCustomerByAgentCode);

router.post("/", isAuth, addAgentCustomer);

module.exports = router;
