const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../../middlewares/routeValidation");
const { customMessage, orderVerified } = require("../../../../controllers/admin/texter");
const router = express.Router();

router.post(
  "/custom",
  [
    body("recipientNumber")
      .isLength({ min: 12, max: 12 })
      .withMessage("Mobile number must be 12 digits")
      .custom((value) => {
        const mobileNumber = String(value);
        if (!mobileNumber.startsWith("639")) {
          throw new Error("Mobile number must start with 639");
        }
        return true;
      }),
    body("custom").notEmpty(),
  ],
  validation,
  customMessage
);

router.post("/order-verified", orderVerified);
module.exports = router;
