const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../../middlewares/routeValidation");
const {
  sendEmailOrderVerification,
  sendBuildCreditEmail,
  sendEmailOrderDenied,
  sendEmailDelivered,
  sendEmailPickedup,
} = require("../../../../controllers/admin/mailer");

const router = express.Router();

// Send Email Order Verification
router.post(
  "/",
  [
    body("receiver_email").notEmpty().isEmail(),
    body("order_reference_no").notEmpty(),
    body("seller_email").optional().isEmail(),
  ],
  validation,
  sendEmailOrderVerification
);

// Send Email to Customer BuildCredit Status
router.post("/build-credit-email", sendBuildCreditEmail);

// Send Email to Customer with their Order Denied status
router.post("/denied-order", sendEmailOrderDenied);

// Send Email to Customer with their Order Delivered status
router.post("/delivered-order", sendEmailDelivered);

// Send Email to Customer with their OrderPickedup
router.post("/pickedup-order", sendEmailPickedup);

module.exports = router;
