const express = require("express");

const mailerRoute = require("./mailer/mailer");
const texterRoute = require("./texter/texter");
const soaRoute = require("./soa/soa");
const permissionsRoute = require("./permissions/permissions");
const buildcreditRoute = require("./buildcredit/buildcredit");
const returnOrderRoute = require("./return-order/return-order");
const bpiRoute = require("./bpi/bpi");
const orderFormRoute = require("./order-form/order-form");
const salesReportRoute = require("./sales-report/sales-report");
const urlHandleRoute = require("./url-handle/url-handle.route");
const deliveryReceipt = require('./delivery-receipt/delivery-receipt');
const pilonRoute = require('./pilon/pilon');

const router = express.Router();

router.use("/mailer", mailerRoute);
router.use("/texter", texterRoute);
router.use("/soa", soaRoute);
router.use("/permissions", permissionsRoute);
router.use("/buildcredit", buildcreditRoute);
router.use("/return-order", returnOrderRoute);
router.use("/bpi", bpiRoute);
router.use("/order-form", orderFormRoute);
router.use("/sales-report", salesReportRoute);
router.use("/url-handle", urlHandleRoute);
router.use("/delivery-receipt", deliveryReceipt);
router.use("/pilon", pilonRoute);

module.exports = router;
