const express = require("express");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");
const pagination = require("../../../middlewares/pagination");

const {
    createProduct,
    getAllProducts,
    getProductById,
    getProductByMenu,
    updateProductById,
    deleteProductById,
    getAllProductMenu
  } = require("../../../controllers/product-menu");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();
// Product Routes
router.post("/create", 
    isAuth,
    jsonParser,
    [
        body("product_menu").notEmpty(),
        body("size_category").optional(),
        body("photo").optional(),
        body("upload_photo").optional(),
    ],
    createProduct);

router.put("/:productId/update", 
    isAuth, 
    jsonParser,
    [
      body("product_menu").notEmpty(),
      body("size_category").optional(),
      body("photo").optional(),
      body("upload_photo").optional(),
    ],
    updateProductById);

router.use(pagination);

router.get("/all", getAllProducts);
router.get("/:product_category/search", getProductById);
router.get("/:productMenu/search-menu", getProductByMenu);
router.delete("/:productId/delete",isAuth,deleteProductById);
router.get("/show-all", getAllProductMenu);

module.exports = router;
