const express = require("express");

const router = express.Router();

const {
  verifyEmailTemplate,
  readyForPickupTemplate,
  readyForDeliveryTemplate,
} = require("../helpers/email-templates/html-bodys-new");
const emailBuilder = require("../helpers/transporter");

router.get("/email-verify", async (req, res, next) => {
  const email = await emailBuilder(
    ["jimboyreyes0@gmail.com"],
    [],
    "Verify your email address",
    true,
    verifyEmailTemplate("Jimboy Reyes", "RandomToken"),
    []
  );

  res.status(200).json({ success: true, email });
});

router.get("/ready-for-pickup", async (req, res, next) => {
  const email = await emailBuilder(
    ["jimboyreyes0@gmail.com"],
    [],
    "Buildhub - Ready for Pickup Order",
    true,
    readyForPickupTemplate("Jimboy Reyes", "ORD123456789"),
    []
  );

  res.status(200).json({ success: true, email });
});

router.get("/ready-for-delivery", async (req, res, next) => {
  const email = await emailBuilder(
    ["jimboyreyes0@gmail.com"],
    [],
    "Buildhub - Ready for Delivery Order",
    true,
    readyForDeliveryTemplate("Jimboy Reyes", "ORD123456789"),
    []
  );

  res.status(200).json({ success: true, email });
});

module.exports = router;
