const express = require("express");

const router = express.Router();

const checkoutRoute = require("./v1/checkout/checkout");
const customersRoute = require("./v1/customers/customers");
const customerRoute = require("./v1/customers/customer");
const creditlimitRoute = require("./v1/creditlimit/creditlimit");
const chatlogistcsRoute = require("./v1/chat-logistics/chat-logistics");
const productMenuRoute = require("./v1/ProductMenu/productmenu");
const sellersRoute = require("./v1/sellers/sellers");
const rpafRoute = require("./v1/rpaf/rpaf");
const orderformdetailsRoute = require("./v1/orderformdetails/orderformdetails");
const rpafpaymentheadRoute = require("./v1/rpafpaymenthead/rpafpaymenthead");
const rpafadminpaymentRoute = require("./v1/rpafadminpayment/rpafadminpayment");
const rpafpaymentRoute = require("./v1/rpafpayment/rpafpayment");
const orderformRoute = require("./v1/orderform/orderform");
const sellersCompanyRoute = require("./v1/sellers-company/sellers-company");
const orderListRoute = require("./v1/order-list/orderList");
const productRatingRoute = require("./v1/product-rating/productRating");
const cancelOrderRoute = require("./v1/cancel-order/cancelOrder");
const rpafBuildCreditApplicationRoute = require("./v1/rpaf-build-credit-application/rpafBuildCreditApplication");
const trackOrdersRoute = require("./v1/track-orders/track-orders");
const hardwareCreditRoute = require("./v1/hardware-credit/hardware-credit");
const agentCustomerRoute = require("./v1/agent-customer/agent-customer");

const voucherRoute = require("./v1/voucher/voucher");
const driverRoute = require("./v1/driver/driver");
const productsRoute = require("./v1/products/products");
const trucksRoute = require("./v1/trucks/trucks");
const truckTypeRoute = require("./v1/truck-type/truck-type");
const logisticsRoute = require("./v1/logistics/logistics");
const logisticsUserRoute = require("./v1/logistics-user/logistics-user");
const logisticPaymentRoute = require("./v1/logistic-payment/logisticPayment");
const locationRoute = require("./v1/location/location");
const announcementsRoute = require("./v1/announcements/announcements");
const areaRoute = require("./v1/area/area");
const userCartRoute = require("./v1/user-cart/user-cart");
const featureProductsRoute = require("./v1/feature-products/feature-products");
const chatsRoute = require("./v1/chats/chats");
// const conversationsRoute = require('./v1/conversations/conversations');
const sellerRatingRoute = require("./v1/seller-rating/seller-rating");
const phoneVerificationRoute = require("./v1/phone-verification/phone-verification");
// const quotationRoute = require("./v1/quotation/quotation.route");
// SELLER
const sellerRoute = require("./v1/seller/seller");
// SELLER

// ADMIN
const adminRoute = require("./v1/admin/admin");
const MobileVersions = require("../models/MobileVersions");
// ADMIN

// CUSTOMER
router.use("/accounts", customersRoute);
router.use("/voucherController", voucherRoute);
router.use("/chat-logistics", chatlogistcsRoute);
router.use("/driverController", driverRoute);
router.use("/checkout", checkoutRoute);
router.use("/customer", customerRoute);
router.use("/credit-limit", creditlimitRoute);
router.use("/voucher", voucherRoute);
router.use("/driver", driverRoute);
router.use("/trucks", trucksRoute);
router.use("/truckType", truckTypeRoute);
router.use("/logistics", logisticsRoute);
router.use("/logisticsUser", logisticsUserRoute);
router.use("/logistic-payment", logisticPaymentRoute);
router.use("/location", locationRoute);
router.use("/announcements", announcementsRoute);
router.use("/area", areaRoute);
router.use("/user-cart", userCartRoute);
router.use("/feature-products", featureProductsRoute);
router.use("/chats", chatsRoute);
// router.use('/conversations', conversationsRoute);

router.use("/products", productsRoute);
router.use("/product-menu", productMenuRoute);
router.use("/sellers", sellersRoute);
router.use("/rpaf", rpafRoute);
router.use("/order-form-details", orderformdetailsRoute);
router.use("/rpaf-payment-head", rpafpaymentheadRoute);
router.use("/rpaf-admin-payment", rpafadminpaymentRoute);
router.use("/rpaf-payment", rpafpaymentRoute);
router.use("/order-form", orderformRoute);
router.use("/sellers-company", sellersCompanyRoute);
router.use("/order-list", orderListRoute);
router.use("/product-rating", productRatingRoute);
router.use("/cancel-order", cancelOrderRoute);
router.use("/rpaf-build-credit-application", rpafBuildCreditApplicationRoute);
router.use("/track-orders", trackOrdersRoute);
router.use("/hardware-credit", hardwareCreditRoute);
router.use("/agent-customer", agentCustomerRoute);
router.use("/seller-rating", sellerRatingRoute);
router.use("/phone-verification", phoneVerificationRoute);
// router.use("/quotation", quotationRoute);
// CUSTOMER

// SELLER
router.use("/seller", sellerRoute);
// SELLER

// ADMIN
router.use("/admin", adminRoute);
// ADMIN

router.get("/version", (req, res, next) => {
  res.status(200).json({ success: true, API_VERSION: "2.0.4", LAST_UPDATED: "April 10, 2025 3:00 PM" });
});
router.get("/mobile-versions", async (req, res, next) => {
  const mobileVersions = await MobileVersions.findAll();
  res.status(200).json({ success: true, versions: mobileVersions });
});

module.exports = router;
