const express = require("express");

const router = express.Router();

const productsRoute = require("../routes/v2/products/products");
const userCart = require("../routes/v2/user-cart/user-cart");
const meRoute = require("../routes/v2/me/me");
const rpafRoute = require("../routes/v2/rpaf-build-credit-application/rpaf-build-credit-application");
const internalFormRoute = require("./v2/internal-form/internal-form");
const sellersCompanyRoute = require("./v2/sellers-company/sellers-company");
const orderListRoute = require("./v2/order-list/order-list");
const impersonateRoute = require("./v2/agent/impersonate");
const orderFormRoute = require("./v2/order-form/order-form");
const chatAdminRoute = require("./v2/admin/chat-admin");
const shippingFeeRoute = require("./v2/shipping-fee/shipping-fee");
const moveTmpImgRoute = require("./v2/move-tmp-img/move-tmp-img");
const accountsRoute = require("./v2/accounts/accounts");
const buildcreditRoute = require("./v2/build-credit/build-credit");
const paynamicsRoute = require("./v2/paynamics/paynamics");

router.use("/products", productsRoute);
router.use("/cart", userCart);
router.use("/me", meRoute);
router.use("/rpaf-build-credit-application", rpafRoute);
router.use("/internal-form", internalFormRoute);
router.use("/sellers-company", sellersCompanyRoute);
router.use("/order-list", orderListRoute);
router.use("/impersonation", impersonateRoute);
router.use("/order-form", orderFormRoute);
router.use("/admin", chatAdminRoute);
router.use("/shipping-fee", shippingFeeRoute);
router.use("/move-tmp-img", moveTmpImgRoute);

router.use("/accounts", accountsRoute);
router.use("/build-credit", buildcreditRoute);
router.use("/paynamics", paynamicsRoute);

module.exports = router;
