const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const Vouchers = sequelizeConnect.define(
  "voucher",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    voucher_code: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    amount_in_percent: {
      type: Sequelize.DECIMAL(8, 8),
      allowNull: true,
    },
    agent: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    status: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    valid_until: {
      type: Sequelize.DATE,
      allowNull: false,
    },
    in_percent: {
      type: Sequelize.ENUM("Yes", "No"),
      allowNull: true,
    },
    seller_voucher: {
      type: Sequelize.INTEGER,
      allowNull: true,
    },
    available_to_child: {
      type: Sequelize.BOOLEAN,
      allowNull: true,
    },
    parent_company_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    product_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
  },
  {
    tableName: "voucher",
    timestamps: false,
  }
);

module.exports = Vouchers;
