const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Products = require("./Products"); // Import Products model
const ProductsVariation = require("./ProductVariation");
const ProductSubVariation = require("./ProductSubVariation");

const UserCart = sequelizeConnect.define(
  "user_cart",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    user_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    menu_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    quantity: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    has_sub_variation_chosen: {
      type: Sequelize.ENUM("true", "false"),
      allowNull: false,
      defaultValue: "false",
    },
    product_variation_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    product_sub_variation_id: {
      type: Sequelize.BIGINT,
      allowNull: true, // Allow null values for product_sub_variation_id
    },
    created_at: {
      type: Sequelize.DATE,
      allowNull: false,
    },
    price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
  },
  {
    tableName: "user_cart",
    timestamps: false,
  }
);
UserCart.belongsTo(Products, { foreignKey: "menu_id", as: "product" });

UserCart.belongsTo(ProductsVariation, {
  foreignKey: "product_variation_id",
  as: "product_variation",
});
UserCart.belongsTo(ProductSubVariation, {
  foreignKey: "product_sub_variation_id",
  as: "product_sub_variation",
});

module.exports = UserCart;
