const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const Trucks = sequelizeConnect.define(
  "trucks",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    logistics_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    group_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    current_lat: {
      type: Sequelize.DOUBLE,
      allowNull: false,
    },
    current_long: {
      type: Sequelize.DOUBLE,
      allowNull: false,
    },   
    driver_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },  
    truck_plate_no: {
      type: Sequelize.STRING(255),
      allowNull: false,
    },  
    truck_type: {
      type: Sequelize.STRING(255),
      allowNull: true,
    },  
    
},
{
    tableName: "trucks",
    timestamps: false,
    
})

module.exports = Trucks;
