const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const SuggestedVouchers = sequelizeConnect.define(
  "suggested_vouchers",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    description: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    seller_company_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    min_amount_requirement: {
      type: Sequelize.DOUBLE,
      allowNull: false,
    },
    max_amount_requirement: {
      type: Sequelize.DOUBLE,
      allowNull: false,
    },
    voucher_amount: {
      type: Sequelize.DOUBLE,
      allowNull: false,
    },
    valid_until: {
      type: Sequelize.DATE,
      allowNull: false,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "suggested_vouchers",
    timestamps: true,
  }
);

module.exports = SuggestedVouchers;
