const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const SplitPayments = sequelizeConnect.define(
  "split_payments",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    rpaf_payment: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    bank_payment: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },

},

{
    tableName: "split_payments",
    timestamps: false,
    
})

module.exports = SplitPayments;
