const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const SellersCompany = require("./SellersCompany");

const SellersCompanyWarehouses = sequelizeConnect.define(
  "sellers_company_warehouses",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    name: {
      type: Sequelize.STRING(300),
      allowNull: false,
    },
    location: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    longitude: {
      type: Sequelize.DOUBLE,
      allowNull: false,
    },
    latitude: {
      type: Sequelize.DOUBLE,
      allowNull: false,
    },
    computation_method: {
      type: Sequelize.ENUM("PerKM", "Fixed"),
      allowNull: true,
    },
    small_item_perkm: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
    },
    small_item_fixed: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
    },
    big_item_perkm: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
    },
    big_item_fixed: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
    },
    small_item_flagdown_perkm: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
    },
    big_item_flagdown_perkm: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "sellers_company_warehouses",
    timestamps: false,
  }
);

SellersCompanyWarehouses.hasMany(SellersCompany, {
  foreignKey: "warehouse_id",
  as: "seller_warehouse",
});
SellersCompany.belongsTo(SellersCompanyWarehouses, {
  foreignKey: "warehouse_id",
  as: "seller_warehouse",
});

module.exports = SellersCompanyWarehouses;
