const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Products = require("./Products");
const MicrositeHandles = require("./MicrositeHandles");

const SellersCompany = sequelizeConnect.define(
  "sellers-company",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    company_name: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    company_description: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    address: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    shop_name: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    shop_location_municipality: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    shop_location_province: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    url_handle: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    microsite_handle_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    latitude: {
      type: Sequelize.DOUBLE,
      allowNull: true,
    },
    longitude: {
      type: Sequelize.DOUBLE,
      allowNull: true,
    },
    warehouse_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    owner: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    seller_logo: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    computation_method: {
      type: Sequelize.STRING(50),
      allowNull: true,
    },
    emailAddress: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    contact_number: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    isParentCompany: {
      type: Sequelize.STRING(50),
      allowNull: true,
    },
    parent_company: {
      type: Sequelize.INTEGER,
      allowNull: true,
    },
    small_item_fee_perkm: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.0,
    },
    small_item_fee_fixed: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.0,
    },
    big_item_fee_perkm: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.0,
    },
    big_item_fee_fixed: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.0,
    },
    flagdownBigKM: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    flagdownSmallKM: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    in_house_small_per_km: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    in_house_small_fixed: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    in_house_big_per_km: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    in_house_big_fixed: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    in_house_flagdown_big_km: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    in_house_flagdown_small_km: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    seller_banner_image: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    seller_banner_image_upload: {
      type: Sequelize.STRING(500),
    },
    seller_type: {
      type: Sequelize.ENUM("Internal", "External"),
      allowNull: true,
    },
    phone_number_primary: {
      type: Sequelize.STRING(50),
      allowNull: true,
    },
    phone_number_optional: {
      type: Sequelize.STRING(50),
      allowNull: true,
    },
    phone_number_optional_2: {
      type: Sequelize.STRING(50),
      allowNull: true,
    },
    enabled_seller_shipping: {
      type: Sequelize.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    seller_radius_shipping: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    seller_logo_url: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    seller_banner_url: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    seller_dashboard_src: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "sellers_company",
    timestamps: false,
  }
);

SellersCompany.hasMany(Products, {
  foreignKey: "seller_id",
  as: "products",
});
Products.belongsTo(SellersCompany, {
  foreignKey: "seller_id",
  as: "seller",
});
SellersCompany.belongsTo(MicrositeHandles, {
  foreignKey: "microsite_handle_id",
  as: "microsite_handle",
});

module.exports = SellersCompany;
