const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const SellerUnivTopicVideos = sequelizeConnect.define(
  "seller_univ_topic_videos",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    seller_univ_topic_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    video_title: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    video_description: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    video_filename: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    video_url: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    video_thumbnail: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    views_count: {
      type: Sequelize.BIGINT,
      allowNull: false,
      defaultValue: 0,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "seller_univ_topic_videos",
    timestamps: true,
  }
);

module.exports = SellerUnivTopicVideos;
