const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const SellerUnivArticles = require("./SellerUnivArticles");
const SellerUnivVideos = require("./SellerUnivVideos");

const SellerUnivTopics = sequelizeConnect.define(
  "seller_univ_topics",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    topic_title: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    topic_description: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    topic_image: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    php_topic_image: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    Guid: {
      type: Sequelize.UUIDV4,
      defaultValue: Sequelize.UUIDV4,
      allowNull: false,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "seller_univ_topics",
    timestamps: true,
  }
);

SellerUnivTopics.hasMany(SellerUnivArticles, {
  foreignKey: "seller_univ_topic_id",
  as: "topic_articles",
});

SellerUnivTopics.hasMany(SellerUnivVideos, {
  foreignKey: "seller_univ_topic_id",
  as: "topic_videos",
});

SellerUnivArticles.belongsTo(SellerUnivTopics, {
  foreignKey: "seller_univ_topic_id",
  as: "topic",
});

SellerUnivVideos.belongsTo(SellerUnivTopics, {
  foreignKey: "seller_univ_topic_id",
  as: "topic",
});

module.exports = SellerUnivTopics;
