const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const SellerUnivTopicArticles = sequelizeConnect.define(
  "seller_univ_topic_articles",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    seller_univ_topic_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    article_title: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    article_description: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    article_content: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "seller_univ_topic_articles",
    timestamps: true,
  }
);

module.exports = SellerUnivTopicArticles;
