const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const Seller = sequelizeConnect.define(
  "sellers",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    seller_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    name: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    username: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    password: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    role: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    seller_logo: {
      type: Sequelize.STRING(250),
      allowNull: true,
    },
    description: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    lat: {
      type: Sequelize.DOUBLE,
      allowNull: true,
    },
    long: {
      type: Sequelize.DOUBLE,
      allowNull: true,
    },
    address: {
      type: Sequelize.STRING(255),
      allowNull: true,
    },
    isAuthorizedWarehouse: {
      type: Sequelize.ENUM("Yes", "No"),
      allowNull: true,
    },
  },
  {
    tableName: "sellers",
    timestamps: false,
  }
);

module.exports = Seller;
