const Sequelize = require('sequelize');
const sequelizeConnect = require('../connection/db');

const RpafPaymentHead = sequelizeConnect.define('rpaf_payment_head', {
    id: {
        type: Sequelize.BIGINT,
        primaryKey: true,
        allowNull: false,
        autoIncrement: true,
    },
    reference_no: {
        type: Sequelize.STRING(150),
        allowNull: false,
      },
      file_attach: {
        type: Sequelize.STRING(500),
        allowNull: true,
      },
      cheque_amount: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },
      actual_amount_paid: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: true,
      },
      CWT: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },
    }, {
      tableName: 'rpaf_payment_head',
      timestamps: false,
    });
    
    module.exports = RpafPaymentHead;