const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const RpafPayment = sequelizeConnect.define(
  "rpaf_payment",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    reference_no: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    cheque_no: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    customer_id: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    order_id: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    amount_paid: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
    },
    remainBalance: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    file_attach: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    date: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    is_pdc_payment: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    cheque_date: {
      type: Sequelize.DATEONLY,
      allowNull: true,
    },
    cheque_number: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    bank: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    status: {
      type: Sequelize.ENUM("Verified", "Denied", "Pending"),
      allowNull: false,
    },
  },
  {
    tableName: "rpaf_payment",
    timestamps: false,
  }
);

module.exports = RpafPayment;
