const Sequelize = require('sequelize');
const sequelizeConnect = require('../connection/db');

const RpafAdminPayment = sequelizeConnect.define('rpaf_admin_payment', {
    id: {
        type: Sequelize.BIGINT,
        primaryKey: true,
        allowNull: false,
        autoIncrement: true,
    },
    customer_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
      },
    order_no: {
        type: Sequelize.STRING(150),
        allowNull: false,
      },
    invoice_amount: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },
    bal: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },
    amount_paid: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },
    cwt_amount: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },
    net_amount: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },

    }, {
      tableName: 'rpaf_admin_payment',
      timestamps: false,
    });
    
    module.exports = RpafAdminPayment;