const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Customers = require("./Customers");

const Rpaf = sequelizeConnect.define(
  "rpaf",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    status: {
      type: Sequelize.ENUM("Approved", "Suspended", "Pending", "Draft"),
      allowNull: false,
    },
    remarks: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    agent_email: {
      type: Sequelize.STRING(100),
      allowNull: true,
      isEmail: {
        args: true,
        msg: "Please enter a valid email address",
      },
    },
    agent_code: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    applicant_signature: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    credit_limit: {
      type: Sequelize.STRING(100),
      allowNull: false,
    },
    company_name: {
      type: Sequelize.STRING(100),
      allowNull: false,
    },
    contact_person: {
      type: Sequelize.STRING(100),
      allowNull: false,
    },
    company_email: {
      type: Sequelize.STRING(100),
      allowNull: false,
      isEmail: {
        args: true,
        msg: "Please enter a valid email address",
      },
    },
    phone: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    addtl_phone: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    landline: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    area: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    address: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    addi_information: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    cement: {
      type: Sequelize.DECIMAL(65, 2),
      allowNull: true,
    },
    finishing: {
      type: Sequelize.DECIMAL(65, 2),
      allowNull: true,
    },
    fixtures: {
      type: Sequelize.DECIMAL(65, 2),
      allowNull: true,
    },
    steel: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    aggregates: {
      type: Sequelize.DECIMAL(65, 2),
      allowNull: true,
    },
    bankName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankBranchName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankAccountName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankManagerName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankAccNum: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankManagerPhone: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankEmail: {
      type: Sequelize.STRING(150),
      allowNull: true,
      isEmail: {
        args: true,
        msg: "Please enter a valid email address",
      },
    },
    storeFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    birFile: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    mayorFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    dtiFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    bankAuthorizationFile: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    otherFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    approvalFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    govFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    tinFileName: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    company__name: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    contact__name: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    address2: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    phone2: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    account_opened: {
      type: Sequelize.DATEONLY,
      allowNull: true,
    },
    credit_date_limit: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    phone3: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    current_bal: {
      type: Sequelize.DECIMAL(65, 2),
      allowNull: true,
    },
    city: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    barangay: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    address_line_1: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    address_line_2: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    is_v2_rpaf: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    date_drafted: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    date_submitted: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    owner_name: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    owner_mobile_number: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    external_source_id: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    form_source: {
      type: Sequelize.STRING(500),
      allowNull: false,
      defaultValue: "Buildhub.ph",
    },
  },
  {
    tableName: "rpaf",
    timestamps: false,
  }
);

Rpaf.belongsTo(Customers, {
  foreignKey: "customer_id",
  as: "customer_detail",
});

module.exports = Rpaf;
