const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const ReturnOrderLog = sequelizeConnect.define(
  "return_order_log",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    order_id: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    product_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    original_quantity: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    return_quantity: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    item_price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
    },
    order_orig_total: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
    },
    order_new_total: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
    },
  },
  {
    tableName: "return_order_log",
    timestamps: false,
  }
);

module.exports = ReturnOrderLog;
