const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const ProductSubVariation = require("./ProductSubVariation");

const ProductVariation = sequelizeConnect.define(
  "product_variation",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    product_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
      allowNull: true,
    },
    variation: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    description: {
      type: Sequelize.STRING(1000),
      allowNull: false,
    },
    quantity_limit: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    discounted_price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    hasSubVariation: {
      type: Sequelize.BOOLEAN,
      allowNull: true,
      defaultValue: 0.0,
      defaultValue: false,
    },
    isAvailable: {
      type: Sequelize.BOOLEAN,
      allowNull: true,
    },
    variationImage: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    sku: {
      type: Sequelize.STRING(300),
      allowNull: false,
    },
    stocks: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
  },
  {
    tableName: "product_variation",
    timestamps: false,
  }
);

ProductVariation.hasMany(ProductSubVariation, { foreignKey: "product_variation_id", as: "ProductSubVariations" });

module.exports = ProductVariation;
