const Sequelize = require('sequelize');
const sequelizeConnect = require('../connection/db');

const ProductSubVariation = sequelizeConnect.define('product_sub_variation', {
    id: {
        type: Sequelize.BIGINT,
        primaryKey: true,
        allowNull: false,
        autoIncrement: true,
    },
    product_variation_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    custom: {
        type: Sequelize.STRING(500),
        allowNull: true
    },
    description: {
        type: Sequelize.STRING(1000),
        allowNull: true
    },
    price: {
        type: Sequelize.DECIMAL(10, 3),
        allowNull: true
    },
    discounted_price: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: true

    },
    quantity_limit: {
        type: Sequelize.BIGINT,
        allowNull: true
    },
    stocks: {
        type: Sequelize.BIGINT,
        allowNull: true,
    },
    sku: {
        type: Sequelize.STRING(300),
        allowNull: true,
        allowNull: false,
    },
    isAvailable: {
        type: Sequelize.BOOLEAN,
        allowNull: true
    },
    photo: {
        type: Sequelize.STRING(300),
        allowNull: false
    },

    
}, {
    tableName: "product_sub_variation",
    timestamps: false
})


module.exports = ProductSubVariation;