const Sequelize = require('sequelize');
const sequelizeConnect = require('../connection/db');

const DetailProductReviews = sequelizeConnect.define('detail_product_reviews', {
    id: {
        type: Sequelize.BIGINT,
        primaryKey: true,
        allowNull: false,
        autoIncrement: true,
    },
    product_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    customer_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    rate: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            isIn: [[0, 1, 2, 3, 4, 5]],
        },
    },
    reviews: {
        type: Sequelize.STRING(200),
        allowNull: true,
    },
    order_form_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    reference_no: {
        type: Sequelize.STRING(150),
        allowNull: false,
    },
    timestamp: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
    }
},
{
    tableName: "detail_product_reviews",
    timestamps: false
})

module.exports = DetailProductReviews;