const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const ProductMenu = sequelizeConnect.define(
  "product_menu",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    product_menu: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    description: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    size_category: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    photo: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    upload_photo: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "product_menu",
    timestamps: false,
  }
);
ProductMenu.associate = (models) => {
  ProductMenu.belongsTo(models.Products, {
    foreignKey: "menu_id",
    as: "product",
  });
};

module.exports = ProductMenu;
