const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const ProductImages = sequelizeConnect.define(
  "product_images",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    product_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    file_name: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    file_path: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "product_images",
    timestamps: true,
  }
);

module.exports = ProductImages;
