const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const PilonInvoicesFiles = sequelizeConnect.define(
  "pilon_invoices_files",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    pilon_invoice_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    file_name: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    file_type: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    system_status: {
        type: Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: true
    },
    createdAt: {
        type: Sequelize.DATE,
        allowNull: false
    },
    updatedAt: {
        type: Sequelize.DATE,
        allowNull: false
    },
},
{
    tableName: "pilon_invoices_files",
    timestamps: true,
})

module.exports = PilonInvoicesFiles;
