const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const PilonInvoicesFiles = require("./PilonInvoicesFiles");

const PilonInvoices = sequelizeConnect.define(
  "pilon_invoices",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    // Buyer ID (clienCode)
    customer_id: {
        type: Sequelize.BIGINT,
        allowNull: true
    },
    clien_code: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    // Buyer ID (clienCode)

    // Seller Company ID (supplierCode)
    sellers_company_id: {
        type: Sequelize.BIGINT,
        allowNull: true
    },
    supplier_code: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    // Seller Company ID (supplierCode)

    // Invoice Number (invoiceNo)
    invoice_no: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    order_reference_no: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    amount: {
        type: Sequelize.DOUBLE,
        allowNull: true,
        defaultValue: 0
    },
    // Integer Status
    status: {
        type: Sequelize.INTEGER,
        allowNull: true,
    },
    status_description: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    // Value to be passed is in percetage (e.g.: 2%)
    discount_percentage: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    // Discount Percetage converted amount
    discount_amount: {
        type: Sequelize.DOUBLE,
        allowNull: true
    },
    new_payee: {
        type: Sequelize.STRING(400),
        allowNull: true
    },
    fund_request_date: {
        type: Sequelize.DATE,
        allowNull: true
    },
    early_payment_date: {
        type: Sequelize.DATE,
        allowNull: true
    },
    buyer_payment_date: {
        type: Sequelize.DATE,
        allowNull: true
    },
    system_status: {
        type: Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: true
    },
    createdAt: {
        type: Sequelize.DATE,
        allowNull: false
    },
    updatedAt: {
        type: Sequelize.DATE,
        allowNull: false
    },
},
{
    tableName: "pilon_invoices",
    timestamps: true,
})
PilonInvoices.hasMany(PilonInvoicesFiles, {
    foreignKey: "pilon_invoice_id",
    as: "files"
})
PilonInvoicesFiles.belongsTo(PilonInvoices, {
    foreignKey: "pilon_invoice_id",
    as: "invoice"
})

module.exports = PilonInvoices;
