const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const PhoneVerifications = sequelizeConnect.define(
  "PhoneVerifications",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    client_name: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    company_name: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    email_address: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    mobile_number: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    signature: {
      type: Sequelize.STRING,
      allowNull: false,
    },
  },
  {
    tableName: "phoneverifications",
    timestamps: true,
  }
);

module.exports = PhoneVerifications;
