const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const RpafPayments = require("./RpafPayment");

const PdcHistory = sequelizeConnect.define(
  "pdc_history",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    rpaf_payment_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    cheque_number: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    cheque_date: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    cheque_verified_date: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    order_form_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    date_time: {
      type: Sequelize.DATE,
      allowNull: false,
    },
  },
  {
    tableName: "pdc_history",
    timestamps: true,
  }
);

PdcHistory.belongsTo(RpafPayments, {
  foreignKey: "rpaf_payment_id",
  as: "payment_detail",
});

module.exports = PdcHistory;
