const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const PaynamicsTransactions = sequelizeConnect.define(
  "paynamics_transactions",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    order_reference_no: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    response_code: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    response_advise: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    response_message: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    signature: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    response_id: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    merchant_id: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    request_id: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    payment_action_info: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    timestamp: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    payment_success: {
      type: Sequelize.BOOLEAN,
      allowNull: true,
    },
    api_remarks: {
      type: Sequelize.STRING,
      allowNull: true,
    },
  },
  {
    tableName: "paynamics_transactions",
    timestamps: true,
  }
);

module.exports = PaynamicsTransactions;
