const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Customers = require("./Customers");
const SellersCompany = require("./SellersCompany");
const Drivers = require("./Drivers");
const Trucks = require("./Trucks");
const LogisticsCompany = require("./Logistics");

const OrderList = sequelizeConnect.define(
  "order_list",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    reference_no: {
      type: Sequelize.STRING(50),
      allowNull: false,
    },
    encode_date: {
      type: Sequelize.DATE,
      allowNull: false,
    },
    seller_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    status: {
      type: Sequelize.ENUM(
        "Checked Out",
        "Ready For Pickup",
        "Cancelled",
        "Verified",
        "To Received",
        "Ready for Customer Pickup",
        "Delivered"
      ),
      allowNull: false,
    },
    remarks: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    total_amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    voucher_amount: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
      defaultValue: 0,
    },
    payment_method: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },

    shipping_type: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    delivery_fee: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
    },

    address: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    dateTime_verified: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    dateTime_for_preparation: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    dateTime_for_delivery: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    date_delivered: {
      type: Sequelize.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "order_form",
    timestamps: false,
  }
);

OrderList.belongsTo(Customers, {
  foreignKey: "customer_id",
  as: "customer",
});

OrderList.belongsTo(SellersCompany, {
  foreignKey: "seller_id",
  as: "seller",
});

OrderList.belongsTo(Drivers, {
  foreignKey: "driver",
  as: "driver_detail",
});

OrderList.belongsTo(Trucks, {
  foreignKey: "truck",
  as: "truck_detail",
});

OrderList.belongsTo(LogisticsCompany, {
  foreignKey: "logistics_id",
  as: "logistics_detail",
});

module.exports = OrderList;
