const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Products = require("./Products");
const OrderList = require("./OrderList");
const ProductVariation = require("./ProductVariation");
const ProductSubVariation = require("./ProductSubVariation");

const OrderFormDetails = sequelizeConnect.define(
  "order_form_details",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    order_form_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    product_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    variant: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    quantity: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    discounted_price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    voucher_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    voucher_amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    rated: {
      type: Sequelize.BOOLEAN,
      defaultValue: false,
    },
    has_sub_variation_chosen: {
      type: Sequelize.ENUM("true", "false"),
      allowNull: true,
    },
    product_variation_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    product_sub_variation_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    reference_no: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
  },
  {
    tableName: "order_form_details",
    timestamps: false,
  }
);

OrderFormDetails.belongsTo(Products, {
  foreignKey: "product_id",
  as: "product",
});

OrderFormDetails.belongsTo(ProductVariation, {
  foreignKey: "product_variation_id",
  targetKey: "id",
  as: "variation",
});

OrderFormDetails.belongsTo(ProductSubVariation, {
  foreignKey: "product_sub_variation_id",
  targetKey: "id",
  as: "sub_variation",
});

module.exports = OrderFormDetails;
