const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const RpafPayment = require("./RpafPayment");
const OrderFormDetails = require("./OrderFormDetails");
const Voucher = require("./Vouchers");
const SellersCompany = require("./SellersCompany");
const Customers = require("./Customers");
const Logistics = require("./Logistics");
const MultipleDr = require('./MultipleDR')

const OrderForm = sequelizeConnect.define(
  "order_form",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    email: {
      type: Sequelize.STRING(200),
      allowNull: true,
      isEmail: {
        args: true,
        msg: "Please enter a valid email address",
      },
    },
    name: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    agentCode: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    contact_number: {
      type: Sequelize.STRING(20),
      allowNull: true,
    },
    pickup_date: {
      type: Sequelize.DATEONLY,
      allowNull: true,
    },
    note: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    pickup_method: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    mode_of_payment: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    subtotal_amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    total_amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    proof_of_payment: {
      type: Sequelize.STRING(5000),
      allowNull: true,
    },
    pickup_by: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    released_by: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    encode_date: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    reference_no: {
      type: Sequelize.STRING(50),
      allowNull: true,
    },
    payment_date: {
      type: Sequelize.DATEONLY,
      allowNull: true,
    },
    status: {
      type: Sequelize.ENUM(
        "Delivered",
        "Ready for Pickup",
        "Cancelled",
        "Verified",
        "To Received",
        "Ready for Customer Pickup",
        "Received",
        "Denied",
        "To Deliver",
        "Pending"
      ),
      allowNull: true,
    },
    total_qty: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    released_status: {
      type: Sequelize.STRING(100),
      allowNull: true,
    },
    released_date: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    pickup_location: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    address: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    longitude: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    latitude: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    pickup_datetime: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    payment_method: {
      type: Sequelize.ENUM("RPAF", "Build Credit", "Bank Transfer", "Split", "Hardware Credit", "Credit Card"),
      allowNull: true,
    },
    date_created: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    rpaf_due_date: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    total_distance: {
      type: Sequelize.FLOAT(11, 2),
      allowNull: true,
    },
    delivery_fee: {
      type: Sequelize.FLOAT(11, 2),
      allowNull: true,
    },
    shipping_type: {
      type: Sequelize.ENUM("Standard Shipping", "Pick-up", "Transportify", "Lalamove", "Hardware Shipping"),
      allowNull: true,
    },
    delivery_status: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    signature: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    seller_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    driver: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    truck: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    date_delivered: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    delivered_picture: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    voucher_id_used: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    suggested_voucher_id_used: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    dateTime_verified: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    dateTime_for_preparation: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    dateTime_ready_pickup: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    dateTime_for_delivery: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    logistics_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    pickup_photo: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    upload_pickup_photo: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    remarks: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    split_payment_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    cancel_reason: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    release_order_image: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    release_order_image_new_src: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    warehouse_delivery_release_image: {
      type: Sequelize.STRING(1000),
      allowNull: true,
    },
    admin_remarks: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    absolute_logistics_fee: {
      type: Sequelize.DECIMAL(10, 4),
      allowNull: true,
    },
    logistics_fee: {
      type: Sequelize.DECIMAL(10, 4),
      allowNull: true,
    },
    loading_fee: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    unloading_fee: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: true,
    },
    order_verified_by: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    has_sub_variation_chosen: {
      // Define the new column
      type: Sequelize.ENUM("true", "false"),
      allowNull: true,
    },
    product_variation_id: {
      // Define the new column
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    product_sub_variation_id: {
      // Define the new column
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    payment_reference_number: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    payment_status: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    is_v2_order: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    is_waived: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    voucher_amount: {
      type: Sequelize.DECIMAL(10, 5),
      allowNull: true,
      defaultValue: 0,
    },
    po_attachment: {
      type: Sequelize.STRING,
      allowNull: true,
    },
  },
  {
    tableName: "order_form",
    timestamps: false,
  }
);

OrderForm.hasMany(RpafPayment, {
  foreignKey: "order_id",
  sourceKey: "reference_no",
  as: "rpaf_payment",
});
RpafPayment.belongsTo(OrderForm, {
  foreignKey: "order_id",
  targetKey: "reference_no",
  as: "order_form_detail",
});
OrderForm.hasMany(OrderFormDetails, {
  foreignKey: "order_form_id",
  as: "order_form_details",
});
OrderFormDetails.belongsTo(OrderForm, {
  foreignKey: "order_form_id",
  as: "order_form",
});
OrderForm.belongsTo(Voucher, {
  foreignKey: "voucher_id_used",
  as: "voucher_details",
});
OrderForm.belongsTo(SellersCompany, {
  foreignKey: "seller_id",
  as: "sellers_company_details",
});
OrderForm.belongsTo(Customers, {
  foreignKey: "customer_id",
  as: "customer_detail",
});

OrderForm.belongsTo(Logistics, {
  foreignKey: "logistics_id",
});

Customers.hasMany(OrderForm, {
  foreignKey: "customer_id",
  as: "order_form_details",
});

SellersCompany.hasMany(OrderForm, {
  foreignKey: "seller_id",
  as: "order_form_details",
});

Logistics.hasMany(OrderForm, {
  foreignKey: "logistics_id",
  as: "order_form_details",
});
OrderForm.hasMany(MultipleDr, {
  foreignKey: "reference_no",
  sourceKey: "reference_no",
  as: "delivery_receipts"
})
module.exports = OrderForm;
