const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const Area = sequelizeConnect.define(
  "tbl_multiple_dr",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    reference_no: {
      type: Sequelize.STRING(100),
      allowNull: false,
    },
    status: {
      type: Sequelize.STRING(100),
      allowNull: false,
    },
    driver: {
      type: Sequelize.STRING(100),
      allowNull: false,
    },
    delivered_picture: {
      type: Sequelize.STRING(100),
      allowNull: false,
    },
    date_created: {
      type: Sequelize.DATE,
      allowNull: false,
    },
  },
  {
    tableName: "tbl_multiple_dr",
    timestamps: false,
  }
);

module.exports = Area;
