const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const MobileVersions = sequelizeConnect.define(
  "mobile_versions",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    app_type: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    app_version: {
      type: Sequelize.DOUBLE,
      allowNull: true,
    },
    app_release_date: {
      type: Sequelize.DATE,
      allowNull: true,
    },
    addi_flags_1: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    addi_flags_2: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    addi_flags_3: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "mobile_versions",
    timestamps: false,
  }
);

module.exports = MobileVersions;
