const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const MicrositeHandles = sequelizeConnect.define(
  "microsite_handles",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    microsite: {
      type: Sequelize.STRING(500),
      allowNull: true,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "microsite_handles",
    timestamps: false,
  }
);

module.exports = MicrositeHandles;
