const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const MessagesLogs = sequelizeConnect.define(
  "messages_logs",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    type: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    receiver: {
      type: Sequelize.TEXT,
      allowNull: false,
    },
    content: {
      type: Sequelize.TEXT,
      allowNull: false,
    },
    is_sent: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "messages_logs",
    timestamps: true,
  }
);

module.exports = MessagesLogs;
