const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const LogisticsUser = sequelizeConnect.define(
  "logistics_user",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    logistics_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    Username: {
      type: Sequelize.STRING(50),
      allowNull: true,
    },
    password: {
        type: Sequelize.STRING(50),
        allowNull: true,
      },
      Fullname: {
        type: Sequelize.STRING(50),
        allowNull: true,
      },
      position: {
        type: Sequelize.STRING(50),
        allowNull: true,
      },
      role: {
        type: Sequelize.STRING(50),
        allowNull: true,
      },
      email_address: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      cost_center: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
      service_center: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
      department: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
      employee_name: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
      employee_name1: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
      roles: {
        type: Sequelize.STRING(150),
        allowNull: true,
      },
    
},
{
    tableName: "logistics_user",
    timestamps: false,
    
})

module.exports = LogisticsUser;
