const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const Logistics = sequelizeConnect.define(
  "logistics",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    company_name: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    address: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    owner: {
        type: Sequelize.STRING(150),
        allowNull: false,
      },
      initial_username: {
        type: Sequelize.STRING(300),
        allowNull: true,
      },
      intiial_password: {
        type: Sequelize.STRING(300),
        allowNull: true,
      },
    
},
{
    tableName: "logistics",
    timestamps: false,
    
})

module.exports = Logistics;
