const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const LogisticPayment = sequelizeConnect.define('logistic_payment', {
    id: {
        type: Sequelize.BIGINT,
        primaryKey: true,
        allowNull: false,
        autoIncrement: true,
    },
    reference_no: {
        type: Sequelize.STRING(150),
        allowNull: false,
    },
    cheque_ref_no: {
        type: Sequelize.STRING(500),
        allowNull: true,
        defaultValue: null,
    },
    customer_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    order_id: {
        type: Sequelize.STRING(150),
        allowNull: false,
    },
    logistics_fee: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
    },
    remaining_balance: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
    },
    amount_paid: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
    },
    file_attach: {
        type: Sequelize.STRING(150),
        allowNull: true,
    },
    php_file_attach: {
        type: Sequelize.STRING(300),
        allowNull: true,
    },
    EWT: {
        type: Sequelize.DECIMAL(10, 3),
        allowNull: true,
    },
}, {
    tableName: 'logistic_payment',
    timestamps: false,
});

module.exports = LogisticPayment;