const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const Location = sequelizeConnect.define(
  "location",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    vehicle_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    order_id: {
      type: Sequelize.STRING(150),
      allowNull: true,
    },
    date: {
        type: Sequelize.DATEONLY,
        allowNull: false,
      },
      time: {
        type: Sequelize.TIME,
        allowNull: false,
      },
      latitude: {
        type: Sequelize.DOUBLE,
        allowNull: false,
      },
      longtitude: {
        type: Sequelize.DOUBLE,
        allowNull: false,
      },
    
},
{
    tableName: "location",
    timestamps: false,
    
})

module.exports = Location;
