const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const InternalFormsFields = require("./InternalFormFields");

const InternalForms = sequelizeConnect.define("InternalForms", {
  id: {
    type: Sequelize.UUID,
    defaultValue: Sequelize.UUIDV4,
    primaryKey: true,
    allowNull: false,
  },
  form_title: {
    type: Sequelize.STRING,
    allowNull: false,
  },
  form_sub_title: {
    type: Sequelize.STRING,
    allowNull: true,
  },
});

InternalForms.hasMany(InternalFormsFields, {
  foreignKey: "internal_form_id",
  as: "internal_form_fields",
});

module.exports = InternalForms;
