const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const CustomFieldsTypes = require("./CustomFieldsTypes");

const InternalFormFieldsDependentInputs = sequelizeConnect.define(
  "InternalFormFieldsDependentInputs",
  {
    id: {
      type: Sequelize.UUID,
      defaultValue: Sequelize.UUIDV4,
      primaryKey: true,
      allowNull: false,
    },
    internal_form_field_id: {
      type: Sequelize.UUID,
      allowNull: false,
    },
    option: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    same_hierarchy: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    unique_code: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    field_type_id: {
      type: Sequelize.UUID,
      allowNull: false,
    },
    field_name: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    sort_order: {
      type: Sequelize.INTEGER,
      allowNull: true,
    },
    is_required: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
    },
    is_autocompute: {
      type: Sequelize.BOOLEAN,
      allowNull: true,
    },
    formula: {
      type: Sequelize.STRING,
      allowNull: true,
    },
  }
);
InternalFormFieldsDependentInputs.belongsTo(CustomFieldsTypes, {
  foreignKey: "field_type_id",
  as: "custom_field_type",
});

module.exports = InternalFormFieldsDependentInputs;
