const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const InternalFormFieldsDependentInputs = require("./InternalFormFieldsDependentInputs");
const CustomFieldsTypes = require("./CustomFieldsTypes");

const InternalFormsFields = sequelizeConnect.define("InternalFormsFields", {
  id: {
    type: Sequelize.UUID,
    defaultValue: Sequelize.UUIDV4,
    primaryKey: true,
    allowNull: false,
  },
  code: {
    type: Sequelize.STRING,
    allowNull: false,
  },
  internal_form_id: {
    type: Sequelize.UUID,
    allowNull: false,
  },
  custom_field_type_id: {
    type: Sequelize.UUID,
    allowNull: false,
  },
  unique_code: {
    type: Sequelize.STRING,
    allowNull: true,
  },
  is_autocompute: {
    type: Sequelize.BOOLEAN,
    allowNull: true,
  },
  formula: {
    type: Sequelize.STRING,
    allowNull: true,
  },
  allow_multiple_values: {
    type: Sequelize.BOOLEAN,
    allowNull: true,
  },
  default_value: {
    type: Sequelize.STRING,
    allowNull: true,
  },
  options: {
    type: Sequelize.STRING,
    allowNull: true,
  },
  has_dependent_fields: {
    type: Sequelize.BOOLEAN,
    allowNull: true,
  },
  field_name: {
    type: Sequelize.STRING,
    allowNull: false,
  },
  sort_order: {
    type: Sequelize.INTEGER,
    allowNull: true,
  },
  is_required: {
    type: Sequelize.BOOLEAN,
    allowNull: false,
  },
});

InternalFormsFields.hasMany(InternalFormFieldsDependentInputs, {
  foreignKey: "internal_form_field_id",
  as: "internal_form_fields_dependent_input",
});
InternalFormsFields.belongsTo(CustomFieldsTypes, {
  foreignKey: "custom_field_type_id",
  as: "custom_field_type",
});

module.exports = InternalFormsFields;
