const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const InactiveCustomerTextMsgHistory = sequelizeConnect.define(
  "inactive_customers_text_msgs_history",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    phone: {
      type: Sequelize.STRING(50),
      allowNull: false,
    },
    last_date_text: {
      type: Sequelize.DATEONLY,
      allowNull: false,
    },
  },
  {
    tableName: "inactive_customers_text_msgs_history",
    timestamps: true,
  }
);

module.exports = InactiveCustomerTextMsgHistory;
