const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Customers = require("./Customers");

const HardwareCreditCustomers = sequelizeConnect.define(
  "hardware_credit_customers",
  {
    id: {
      type: Sequelize.UUID,
      defaultValue: Sequelize.UUIDV4,
      primaryKey: true,
      allowNull: false,
    },
    seller_company_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    customer_credit_limit: {
      type: Sequelize.DECIMAL(10, 4),
      allowNull: false,
    },
    status: {
      type: Sequelize.STRING,
      allowNull: false,
      defaultValue: "Verified",
    },
  }
);

module.exports = HardwareCreditCustomers;
